'use strict'

entityRegistry['module']['threeDeeArrow'] = {
    extendedInfo: {
        displayName: 'Arrows',
        displayGroup: '3D Effects',
    },
    init: (staticConfig) => {
        const {
            seed,
            points,
            range,
            pointRange,
            segments,
            numArrows,
            limitXY,
        } = { ...staticConfig }

        const rng = new Math.seedrandom(seed)
        const arrows = []
        for (let i = 0; i < numArrows; ++i) {
            const dir = randomNormal(rng)
            if (limitXY) dir[2] = 0
            const pointData = [[0, 0, 0]]
            for (let j = 0; j < points; ++j) {
                const offset = randomNormal(rng)
                if (limitXY) offset[2] = 0
                pointData.push(
                    m4.addVectors(
                        m4.multiplyVector(dir, j * range),
                        m4.multiplyVector(offset, j === 0 ? 0 : pointRange)
                    )
                )
            }

            /*
            const pointData = [[0, 0, 0]]
            for (let j = 0; j < points; ++j) {
                const dir = randomNormal(rng)
                if (limitXY) dir[2] = 0
                pointData.push(m4.multiplyVector(dir, j === 0 ? 0 : range))
            }
            */
            const splinePoints = pathToSpline(pointData, segments)//+i*2)
            arrows.push(new ArrowModel(splinePoints))
        }

        return {
            arrows
        }
    },
    staticConfig: [
        { paramName: 'seed', displayName: 'Seed', type: 'string', defaultValue: 'seed', triggerInit: true },
        { paramName: 'points', displayName: 'Points', type: 'int', defaultValue: 10, triggerInit: true },
        { paramName: 'range', displayName: 'Range', type: 'float', defaultValue: 5, triggerInit: true },
        { paramName: 'pointRange', displayName: 'Point Range', type: 'float', defaultValue: 1, triggerInit: true },
        { paramName: 'segments', displayName: 'Segments', type: 'int', defaultValue: 50, triggerInit: true },
        { paramName: 'numArrows', displayName: 'Arrows', type: 'int', defaultValue: 10, triggerInit: true },
        { paramName: 'limitXY', displayName: 'Limit XY', type: 'boolean', defaultValue: false, triggerInit: true },
    ],
    dynamicConfig: [
        { paramName: 'position', displayName: 'Position', type: 'float3', defaultValue: [0, 0, 0]},
        { paramName: 'rotation', displayName: 'Rotation', type: 'angle3', defaultValue: [0, 0, 0]},
        { paramName: 'scale', displayName: 'Scale', type: 'float', defaultValue: 1},
        { paramName: 'widthVariation', displayName: 'Width Variation', type: 'float', defaultValue: .1},
        { paramName: 'bodyLength', displayName: 'Body Length', type: 'float', defaultValue: 10},
        { paramName: 'bodyWidth', displayName: 'Body Width', type: 'float', defaultValue: .1},
        { paramName: 'bodyHeight', displayName: 'Body Height', type: 'float', defaultValue: .1},
        { paramName: 'bodyGap', displayName: 'Body Gap', type: 'float', defaultValue: 3},
        { paramName: 'bodyGapLength', displayName: 'Body Gap Length', type: 'float', defaultValue: 5},
        { paramName: 'headLength', displayName: 'Head Length', type: 'float', defaultValue: 1},
        { paramName: 'headWidth', displayName: 'Head Width', type: 'float', defaultValue: .25},
        { paramName: 'headHeight', displayName: 'Head Height', type: 'float', defaultValue: .25},
        { paramName: 'animation', displayName: 'Animation', type: 'float', defaultValue: 0},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                position,
                rotation,
                scale,
                widthVariation,
                bodyWidth,
                bodyLength,
                bodyHeight,
                bodyGap,
                bodyGapLength,
                headLength,
                headWidth,
                headHeight,
                animation,
            } = { ...config }

const colors = [
    [[.5,0,0],[0.5,0,0]],
    [[.5,0,0], [0.25,0,0]],
    [[0,.5,0],[0,.5,0]],
    [[0,.5,0], [0,0.25,0]],
    [[0,0,.5],[0,0,.5]],
    [[0,0,.5], [0,0,0.25]],
]
colors.forEach((color) => {
    renderer.getPaletteId(color[0], color[1])
})

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            const xRotationMat = m4.xRotation(rotation[0])
            const yRotationMat = m4.yRotation(rotation[1])
            const zRotationMat = m4.zRotation(rotation[2])
            const rotationMat = m4.multiply(m4.multiply(zRotationMat, yRotationMat), xRotationMat)
            const scaleMat = m4.scaling(scale, scale, scale)
            const translationMat = m4.translation(position[0], position[1], position[2])
            const worldMat = m4.multiply(translationMat, m4.multiply(rotationMat, scaleMat))

            const animationPos = animation
            let c = 0
            self.arrows.forEach(arrow => {
                arrow.reset()
                const start = Math.max(0, animationPos-bodyLength-c)
                if (bodyGap > 0) {
                    arrow.addObject(c, Math.max(start-bodyGap-bodyGapLength, 0), Math.max(start-bodyGap, 0),
                        (a,t) => Math.sin(c+t*84)*widthVariation+bodyWidth,
                        (a,t) => Math.sin(c+t*54)*widthVariation+bodyHeight,
                    )
                }
                    arrow.addObject(c, start, animationPos,
                    (a,t) => Math.sin(c+t*84)*widthVariation+bodyWidth,
                    (a,t) => Math.sin(c+t*54)*widthVariation+bodyHeight,
                    true, headWidth, headHeight, headLength
                )
                c+=1
                renderer.drawModel(arrow.getModel(), worldMat, colorBuffer, depthBuffer, brightnessBuffer)
            })
        }
    }
}
